/*


*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <assert.h>
#include <vector>
#include <math.h>

using namespace std;

#ifdef _WIN32
typedef __int64 int64_t;
#else
typedef long long int64_t;
#endif

const int pis2=102944;
const int pi=205887;
const int pi2=411775;

inline int64_t fmult(int64_t x,int64_t y)
{
	return (x*y)>>16;///65536;
}

inline int64_t fsqr(int64_t x)
{
	return fmult(x,x);
}

inline int64_t fdiv(int64_t x, int64_t y)
{
	return (x<<16)/y;//(x*65536)/y;
}

inline int64_t fnorm2(int64_t x, int64_t y)
{
	return fmult(x,x)+fmult(y,y);
}

inline int64_t fscal(int64_t x1, int64_t y1, int64_t x2, int64_t y2)
{
	return fmult(x1,x2)+fmult(y1,y2);
}

int fsin(int x)
{
	if (x<0)
		return -fsin(-x);
	if (x>pis2)
		return fsin(pi-x);
	int x2=(int)fmult(x,x);
	int x3=(int)fmult(x,x2);
	int x5=(int)fmult(x3,x2);
	int x7=(int)fmult(x5,x2);
	return x-x3/6+x5/120-x7/5040;
}

inline int fcos(int x)
{
	x+=pis2;
	if (x>pi)
		x-=pi2;
	return fsin(x);
}

const int A=24;
const int B=36;
const int T=64;
const int L=20000;
const int F0=4;
const int F1=12;
const int F2=24;

const char sqStart='*';
const char sqGoal='!';
const char sqPassable='.';
const int vide=1000000;
const double Pi=2*acos(0);

class Track
{
	int width, height;
	char *map;
	char *trajectoire;
	int *distance;
	int nVide, nReste;
	
public:
	const char *fileName;
	int xStart, yStart;
	int fxStart, fyStart;

	Track():trajectoire(0),map(0),distance(0)
	{
	}

	char& Map(int x, int y)
	{
		return map[width*y+x];
	}

	char fMap(int x, int y)
	{
		return map[width*(y>>16)+(x>>16)];
	}

	int& Distance(int x, int y)
	{
		return distance[width*y+x];
	}

	int fDistance(int x, int y)
	{
		return distance[width*(y>>16)+(x>>16)];
	}

	char &fTraj(int x, int y)
	{
		return trajectoire[width*(y>>16)+(x>>16)];
	}

	void AllowGoal()
	{
		char * m=map;
		int * d=distance;
		for (int i=0; i<width*height; i++)	
		{
			if (*(m++)==sqGoal)
				*d=0;
			d++;
		}
	}
	
	void Open(const char * _fileName)
	{
		cout<<"** Loading map **"<<endl;
		fileName=_fileName;
		cout<<"Loading "<<fileName<<endl;
		char temp[512];
		sprintf(temp,"%s.trk",fileName);
		ifstream F(temp);
		if (F.fail())
			throw "Unable to load track file";

		F>>width;
		F>>height;
		cout<<"Size of track : "<<width<<"x"<<height<<endl;
		map=new char[width*height+1];
		for (int y=0; y<height; y++)
			F>>&map[y*width];

		//On limine les ! qui vont par paire
		char *c=map;
		char *end=&map[height*width];
		while (c<end)
		{
			if (*c==sqGoal && c[1]==sqGoal)
			{
				while (*c==sqGoal)
					*(c++)='r';
			}
			else
				c++;
		}

		trajectoire=new char[width*height];
		memcpy(trajectoire,map,width*height);

		nVide=0;
		for (int y=0; y<height; y++)
			for (int x=0; x<width; x++)
			{
				if (Map(x,y)==sqStart)
				{
					xStart=x;
					fxStart=x<<16;
					yStart=y;
					fyStart=y<<16;
					break;
				}
			}
		cout<<"Starting from "<<xStart<<","<<yStart<<endl;

		cout<<"** Computing distances from goal **"<<endl;
		char distFileName[512];
		sprintf(distFileName,"%s.dis",fileName);
		FILE * D=fopen(distFileName,"rb");
		if (!D)
		{
			Map(xStart,yStart)=sqPassable;
			CalcDist();
			Map(xStart,yStart)=sqStart;
			FILE *D=fopen(distFileName,"wb");
			fwrite(distance,sizeof(int),height*width,D);
			fclose(D);
			SaveDist();
		}
		else
		{
			cout<<"Loaded from "<<distFileName<<endl;
			distance=new int[height*width];
			fread(distance,sizeof(int),height*width,D);
			fclose(D);
		}
	}

	void SaveDist()
	{
		//On enregistre
		int maxDist=0;
		for (int y=0; y<height; y++)
			for (int x=0; x<width; x++)
			{
				if (Distance(x,y)>maxDist && Distance(x,y)!=vide)
					maxDist=Distance(x,y);
			}

		cout<<maxDist;
		if (!maxDist)
			throw "We find that the maximum distance from goal is 0 !";
		
		char temp[512];
		sprintf(temp,"%s_dist%d.raw",fileName,height);
		FILE * G=fopen(temp,"wb");
		for (int y=0; y<height; y++)
			for (int x=0; x<width; x++)
			{
				unsigned char c=(unsigned char)((unsigned int)Distance(x,y)%255);//*255/maxDist);
				fwrite(&c,1,1,G);
			}
		fclose(G);
	}

	void RedVer(Track & tr, int fac)
	{
		width=tr.width/fac;
		height=tr.height/fac;
		map=new char[width*height];
		memset(map,sqPassable,width*height);
		
		for (int y=0; y<tr.height; y++)
			for (int x=0; x<tr.width; x++)
				if (tr.Map(x,y)!=sqPassable && Map(x/fac,y/fac)!=sqGoal)
					Map(x/fac,y/fac)=tr.Map(x,y);
		/*FILE * F=fopen("temp.txt","w");
		for (int y=0; y<height; y++)
		{
			fwrite(&Map(0,y),1,width,F);
			fputc('\n',F);
		}
		fclose(F);*/
	}

	void CalcDist()
	{
		distance=new int[width*height];

		if (height>100)
		{
			Track tr;
			tr.RedVer(*this, 2);
			tr.CalcDist();

			for (int y=0; y<height; y++)
				for (int x=0; x<width; x++)
				{
					if (tr.Distance(x/2,y/2)==vide || tr.Distance(x/2,y/2)==-1)
						Distance(x,y)=vide;
					else
						Distance(x,y)=(tr.Distance(x/2,y/2)+2)*3;
				}
		}
		else
		{
			for (int y=0; y<height; y++)
				for (int x=0; x<width; x++)
				{
					Distance(x,y)=vide;
				}
		}
		
		int xDep=-1, yDep=0, nyDep=0;
		int nVide=0;
		for (int y=0; y<height; y++)
			for (int x=0; x<width; x++)
			{
				if (Map(x,y)==sqGoal && x>0)
				{
					 Map(x-1,y)=sqPassable;
					//Distance(x,y)=0;
					xDep=x-1;
					yDep+=y;
					nyDep++;
				}
				if (Map(x,y)!=sqPassable)
					Distance(x,y)=-1;
				else if (Distance(x,y)==vide)
					nVide++;
			}
		//cout<<"nVide="<<nVide<<endl;
		assert((xDep!=-1) && (nyDep!=0));
		yDep/=nyDep;
		nReste=nVide;
		ChgDist(xDep,yDep,0);
		//cout<<"nReste="<<nReste<<endl;
		cout<<"Finished for the map of height "<<height<<endl;
	}

	void ChgDist(int x, int y, int d)
	{
		if (Distance(x,y)==vide)
		{
			nReste--;
			if (nReste % 100==0)
			{
				cout<<nReste<<"        \r";
				cout.flush();
			}
		}

		Distance(x,y)=d;
		static const int pas=2;
		if (x<width && Distance(x+1,y)!=-1 && Distance(x+1,y)>d+pas)
			ChgDist(x+1,y,d+pas);
		if (x>0 && Distance(x-1,y)!=-1 && Distance(x-1,y)>d+pas)
			ChgDist(x-1,y,d+pas);
		if (y<height && Distance(x,y+1)!=-1 && Distance(x,y+1)>d+pas)
			ChgDist(x,y+1,d+pas);
		if (y>0 && Distance(x,y-1)!=-1 && Distance(x,y-1)>d+pas)
			ChgDist(x,y-1,d+pas);
		static const int p2=3;

		if (Distance(x+1,y+1)!=-1 && Distance(x+1,y+1)>d+p2)
			ChgDist(x+1,y+1,d+p2);
		if (Distance(x+1,y-1)!=-1 && Distance(x+1,y-1)>d+p2)
			ChgDist(x+1,y-1,d+p2);
		if (Distance(x-1,y+1)!=-1 && Distance(x-1,y+1)>d+p2)
			ChgDist(x-1,y+1,d+p2);
		if (Distance(x-1,y-1)!=-1 && Distance(x-1,y-1)>d+p2)
			ChgDist(x-1,y-1,d+p2);
	
	}

	void SauverTraj()
	{
		char temp[512];
		sprintf(temp,"%s_traj.raw",fileName);
		FILE * F=fopen(temp,"wb");
		fwrite(trajectoire,1,width*height,F);
		fclose(F);
	}

	~Track()
	{
		if (map)
			delete[]map;
		if (distance)
			delete[]distance;
		if (trajectoire)
			delete[]trajectoire;
	}
}
track;

const int echant=20;

class Finished
{
public:
	Finished(){}
};

class Car
{
//	int x,y,v,d;
	
//	bool accelerate,brake,turnLeft,turnRight;
	bool final;
	bool finalTourne;
	ofstream commands;
	ofstream dump;
	int globalTimer;

public:
	Car()//:v(0),d(0)
	{
		final=false;
		finalTourne=false;
		globalTimer=0;
	}

	void Race()
	{
		TrajetSimple();
	}

	struct Etape
	{
		int x,y,v,d;
		int xx,yy,vv;//Vraie position
		int duree;
	};

	std::vector<Etape> trajet;

	int DureeEtape(Etape & et1, Etape & et2, Etape & fin)
	{
		//Calcule le temps ncessaire pour aller de t  t+1
		//On a trois parties :
		//une o on tourne et acclre,
		//une o on acclre /ou o on tourne sans acclrer
		//une o on freine
		//1er paramtre : temps pendant lequel on tourne => ok, simplement jusqu' ce
		//que l'angle soit atteint
		//2me paramtre : temps pendant lequel on acclre
	
		int v=et1.vv;
		int x=et1.xx;
		int y=et1.yy;
		int d=et1.d;

		int x2=et2.x;
		int y2=et2.y;
		int v2=et2.v;

		int dt=0;
		int time=0;
		int ti;
		int accelok=-1;
		bool breakok=false;
		int xp=x, yp=y, dp=d, vp=v;
			
		do
		{
			//Est-ce qu'on y arrive en acclrant en tournant ?
			ti=TurnFaceTo(xp,yp,vp,dp,false,-1,x2,y2,v2,fin);
			if (ti>=0)
				break;

			//On essaye sans acclrer
			xp=x;yp=y;dp=d;vp=v;
	
			ti=TurnFaceTo(xp,yp,vp,dp,false,0,x2,y2,v2,fin);
			if (ti>=0)
			{
				/*int tt=ti/5;
				//On essaye un intermdiaire
				Etape fintemp=fin;
				int titemp=ti;
				ti=-1;
				for (int i=2; i>0; i--)
				{
					xp=x;yp=y;dp=d;vp=v;
					ti=TurnFaceTo(xp,yp,vp,dp,false,tt*i,x2,y2,v2,fin);
//					ti=-1;
					if (ti>=0)
					{
						accelok=tt*i;
						break;
					}
				}
				if (ti<0)
				{
					accelok=0;
					fin=fintemp;
					ti=titemp;
					break;
				}*/
						
				accelok=0;
				break;
			}

			//En tournant en freinant ?
			xp=x;yp=y;dp=d;vp=v;
			ti=TurnFaceTo(xp,yp,vp,dp,true,0,x2,y2,v2,fin);
			accelok=0;
			breakok=true;
			if (ti>=0)
				break;
//			cout<<"imp de tourner "<<ti;
			//return -1;
		}
		while (0);

		if (final)
		{
			xp=x;yp=y;dp=d;vp=v;
			finalTourne=true;
			int nti=TurnFaceTo(xp,yp,vp,dp,breakok,accelok,x2,y2,v2,fin);
			assert(nti==ti);
			finalTourne=false;
		}

		return ti;
	}

	void Write(int x, int y, int v, int d, bool brake, bool acc, bool turnLeft,
		bool turnRight)
	{
		globalTimer++;
		dump<<globalTimer<<" "<<x<<" "<<y<<" "<<v<<" "<<d<<endl;
		if (acc)
			commands<<"a";
		if (brake)
			commands<<"b";
		if (turnLeft)
			commands<<"l";
		if (turnRight)
			commands<<"r";
		commands<<".\n";
		track.fTraj(x,y)=127;
		if (track.fMap(x,y)==sqGoal)
			throw Finished();
	}

	int GoTo(int x, int y, int v, int d, int x2, int y2, int v2, Etape & fin)
	{
		//Maintenant on va tout droit en acclrant autant que possible
		//et si besoin en rectifiant la trajectoire
		int time=0;
		int idx=x2-x;
		int idy=y2-y;
		
		while(1)
		{
			bool brake,turnLeft=false,turnRight=false;

			if (BrakeTo(x,y,v,d,x2,y2)>v2)
				brake=true;
			else
			{
				int anglevoulu=int(atan2(y2-y,x2-x)*pi/Pi);
				int dangle=anglevoulu-d;
				if (dangle>pi)
					dangle-=pi2;
				if (dangle<-pi)
					dangle+=pi2;
				int minTourner=(int)fdiv(T,fmult(v,v)+L);
		
				if (dangle<-2*minTourner)
					turnLeft=true;
				else if (dangle>2*minTourner)
					turnRight=true;
				brake=false;
			}
			Move(x,y,v,d,brake,!brake,turnLeft,turnRight);
			if (finalTourne)
				Write(x,y,v,d,brake,!brake,turnLeft,turnRight);
			
			time++;
			if (track.fDistance(x,y)==-1)//crash
			{
//				cout<<"crash";
				return -1;
			}

			int ndx=x2-x;
			int ndy=y2-y;
			static const int64_t limitedxdy=16;
			
			if (fnorm2(ndx,ndy)<limitedxdy || fscal(ndx,ndy,idx,idy)<0)
			{
				fin.duree=time;
				fin.x=x2;
				fin.y=y2;
				fin.v=v2;
				
				fin.xx=x;
				fin.yy=y;
				fin.vv=v;
				fin.d=d;
				if (v>v2*2+500)
					cout<<"trop vite !";
				return time;
			}
			//On a fait un demi-tour ? Echec
			/*if (fscal(ndx,ndy,idx,idy)<0)
			{
				cout<<"demi tour";
				return -1;
			}*/
		}
		return -1;
	}

	/*void DefAngle(int t)
	{
		//Dfinit l'angle en fonction des tapes prcdentes et suivantes
		int dx=trajet[t+1].x-trajet[t-1].x;
		int dy=trajet[t+1].y-trajet[t-1].y;
		double angle=atan2(dy,dx);
		trajet[t].d=int(angle*pi/Pi);
	}*/

	int BrakeTo(int x, int y, int v, int d,
		int x2, int y2)
	{
		int64_t dist2=fnorm2(x2-x,y2-y);
		//dist2=fmult(dist2,0xA<<12);

		int64_t d2=0;
		int xi=x,yi=y;

		do
		{
			v-=B;
			if (v<0)
				return 0;
			d2+=v;
		}
		while (fmult(d2,d2)<dist2);
		//trouver la formule mathmatique
		/*

		do
		{
			v-=int(F0+fmult(F1,v)+fmult(F2,fmult(v,v))+B);
			if (v<0)
				return 0;
			//x+=(int)fmult(v,fcos(d));
			//y+=(int)fmult(v,fsin(d));
			d2+=v;//=fnorm2(x-xi,y-yi);
		}
		while (fmult(d2,d2)<dist2);*/
		return v;
	}

	//Renvoie le temps ncessaire ou -1 si impossible
	int TurnFaceTo(int& x, int& y, int& v, int& d, 
		bool brake, int accelerate, int x2, int y2, int v2,
		Etape & fin)
	{
		int idx=x2-x;
		int idy=y2-y;
		int time=0;
		
		while(1)
		{
			int anglevoulu=int(atan2(y2-y,x2-x)*pi/Pi);
			int dangle=anglevoulu-d;
			if (dangle>pi)
				dangle-=pi2;
			if (dangle<-pi)
				dangle+=pi2;
			bool turnLeft=false,turnRight=false;
			int minTourner=(int)fdiv(T,fmult(v,v)+L);

			if (dangle<-minTourner)
				turnLeft=true;
			else if (dangle>minTourner)
				turnRight=true;
			else
			{
				//Est-ce que a nous laisse le temps de freiner ?
				if (BrakeTo(x,y,v,d,x2,y2)>v2)
				{
					if (brake)
					{
						BrakeTo(x,y,v,d,x2,y2);
						cout<<"heeeu";
					}
					return -2;
				}
				else
				{
					int ti=GoTo(x,y,v,d,x2,y2,v2,fin);
					if (ti>=0)
					{
						fin.duree+=time;
						return time+ti;
					}
					else
						return -1;
				}
			}
	
			if (brake)
			{
				Move(x,y,v,d,true,false,false,false);
				if (finalTourne)
					Write(x,y,v,d,true,false,false,false);
				
				if (track.fDistance(x,y)==-1)//crash
					return -3;
				time++;
			}
			Move(x,y,v,d,false,accelerate?true:false,turnLeft,turnRight);
			if (finalTourne)
				Write(x,y,v,d,false,accelerate?true:false,turnLeft,turnRight);
			
			if (accelerate)
				accelerate--;
			time++;
			if (track.fDistance(x,y)==-1)//crash
				return -3;

			int ndx=x2-x;
			int ndy=y2-y;
			//On a fait un demi-tour ? Echec
			if (fmult(ndx,idx)+fmult(ndy,idy)<0 && v>0)
				return -1;
		}
	}

	void FirstStep()
	{
		//On cre un simple trajet qui va  vitesse nulle par la plus faible pente
		int x=track.xStart;
		int y=track.yStart;
		static const int uneCase=1<<16;

		trajet.resize(trajet.size()+1);
		trajet[0].x=x<<16;
		trajet[0].y=y<<16;
		trajet[0].xx=trajet[0].x;
		trajet[0].yy=trajet[0].y;
		trajet[0].v=0;
		trajet[0].vv=trajet[0].v;
		trajet[0].duree=0;
		trajet[0].d=0;

		int t=1;
		int min=track.Distance(x,y);
		int adxMin=0,adyMin=0;
		do
		{
			//min=track.Distance(x,y);
			int dxMin=0,dyMin=0;
			for (int rayon=3; rayon>=0; rayon--)
			{
				dxMin=0;
				dyMin=0;
			for (int dy=-1; dy<=1; dy++)
			for (int dx=-1; dx<=1; dx++)
			{
				if (dx==0 && dy==0)
					continue;
				if (dx==-adxMin && dy==-adyMin)
					continue;

				int dist=track.Distance(x+dx,y+dy);
				if ((dist<min
					||(dist==min && dx==adxMin && dy==adyMin && dxMin && dyMin))
					&& dist!=-1)
				{
					//On regarde si y'a bien la place autour
					//dans un rayon de 2
					bool place=true;
					if (rayon)
					{
						for (int ix=-rayon; ix<=rayon; ix++)
						{
							if (ix*dx<0)
								continue;
							for (int iy=-rayon; iy<=rayon; iy++)
							{
								if (iy*dy<0)
									continue;

								if (track.Distance(x+dx+ix,y+dy+iy)==-1
									&& track.fMap(x+dx+ix,y+dy+iy)!=sqGoal)
								{
									place=false;
									break;
								}
							}
						}
					}
					if (!place)
						continue;
					min=track.Distance(x+dx,y+dy);
					dxMin=dx;
					dyMin=dy;
				}
			}
				if (dxMin || dyMin)
					break;
			}

			x+=dxMin;
			y+=dyMin;
			if (dxMin==0 && dyMin==0)
			{
				cout<<"dxMin==0 && dyMin==0 t="<<t<<" x="<<x<<" y="<<y<<endl;
				return;
			}
			
			if (adxMin==dxMin && adyMin==dyMin)
			{
				trajet[t-1].x=(x<<16)+(1<<15);
				trajet[t-1].y=(y<<16)+(1<<15);
				trajet[t-1].xx=trajet[t-1].x;
				trajet[t-1].yy=trajet[t-1].y;
				trajet[t-1].v=trajet[t-1].vv=0;
			}
			else
			{
				trajet.resize(trajet.size()+1);
				trajet[t].x=(x<<16)+(1<<15);
				trajet[t].y=(y<<16)+(1<<15);
				trajet[t].xx=trajet[t].x;
				trajet[t].yy=trajet[t].y;
				trajet[t].v=trajet[t].vv=0;
				trajet[t].duree=0;
				trajet[t].d=0;
				t++;
				adxMin=dxMin;
				adyMin=dyMin;
			}
		}
		while (min!=0);
		//int ll=trajet.size()-1;
		//trajet[ll].x+=1<<16;
		//trajet[ll].xx+=1<<16;
		//track.Distance(x,y)=0;
		//track.Distance(x+1,y)=0;
		
		SaveTrajet("%s_base.bin");
	}
	
	bool LoadTrajet(const char * modele)
	{
		char temp[512];
		sprintf(temp,modele,track.fileName);
		FILE * F=fopen(temp,"rb");
		if (!F)
			return false;
		
		size_t l;
		fread(&l,1,sizeof(l),F);
		trajet.resize(l);
		for (size_t t=0; t<trajet.size(); t++)
			fread(&trajet[t],sizeof(Etape),1,F);
		fclose(F);
		cout<<"Loaded trajectory from "<<temp<<endl;
		cout<<"Length of loaded trajectory : "<<l<<endl;
		return true;
	}
	
	void SaveTrajet(const char * modele)
	{
		char temp[512];
		sprintf(temp,modele,track.fileName);
		FILE *F=fopen(temp,"wb");
		size_t l=trajet.size();
		fwrite(&l,1,sizeof(l),F);
		for (size_t t=0; t<trajet.size(); t++)
			fwrite(&trajet[t],sizeof(Etape),1,F);
		fclose(F);		
		cout<<"Trajectory saved to "<<temp<<endl;
		cout<<"Length of saved trajectory : "<<l<<endl;
	}
	
	void TrajetSimple()
	{
		cout<<"** Base trajectory **"<<endl;
				
		if (!LoadTrajet("%s_base.bin"))
			FirstStep();	
	
		UpdateTrajectory();
		
		cout<<"** Remove waypoints **"<<endl;
				
		//On tente d'optimiser en supprimant des tapes
		if (!LoadTrajet("%s_simple.bin"))
			SimplifierTrajectoire();

		
		//On tente d'acclerer progressivement la vitesse  chaque tape
		UpdateTrajectory();
		if (!LoadTrajet("%s_acc.bin"))
			AccelererTrajectoire();
		
		//We try to move waypoints
		int time=UpdateTrajectory();
		MoveWayPoints(1,1);

		int lastTime;

		do		
		{
			lastTime=time;
			UpdateTrajectory();
			SimplifierTrajectoire();

			for (int sens1=-1; sens1<=1; sens1+=2)
				for (int sens2=-1; sens2<=1; sens2+=2)
				{
					UpdateTrajectory();
					MoveWayPoints(sens1,sens2);
				}
			time=UpdateTrajectory();
			AccelererTrajectoire();
		}
		while (time<lastTime);
		
		cout<<"** Final trajectory **"<<endl;
		FinalTrajectory();
	}
	
	void FinalTrajectory()
	{
		char temp[512];
		
		sprintf(temp,"%s.trc",track.fileName);
		commands.open(temp);
		sprintf(temp,"%s.dump",track.fileName);
		dump.open(temp);
		dump<<0<<" "<<trajet[0].x<<" "<<trajet[0].y<<
			" "<<trajet[0].v<<" "<<trajet[0].d<<endl;

		final=true;
		int tempsTot=0;
		size_t last=trajet.size()-1;
		/*trajet[last].x+=1<<16;
		trajet[last].xx+=1<<16;*/

		for (int t=0; t<(int)trajet.size()-2; t++)
		{
			Etape et;
			int ret=DureeEtape(trajet[t],trajet[t+1],et);
			if (ret<0)
			{
				cout<<"Erreur en "<<t<<endl;
				return;
			}
			trajet[t+1]=et;
			tempsTot+=et.duree;
			track.fTraj(trajet[t].xx,trajet[t].yy)=0;
		}
		final=false;

		//We add some moves to reach the goal

		//We remove the barrier of the goal
		track.AllowGoal();		
		
		trajet[last].v=trajet[last].vv=1<<16;
		Etape et;
		int ret=DureeEtape(trajet[last-1],trajet[last],et);
		if (ret<0)
           	trajet[last].v=trajet[last].vv=0;

		final=true;
		ret=DureeEtape(trajet[last-1],trajet[last],et);
		if (ret<0)
			throw "The end of the trajectory failed";

		Etape fin=trajet[last];
		fin.xx+=1<<16;
		fin.x+=1<<16;
		fin.v=fin.vv=1<<16;
		ret=DureeEtape(et,fin,et);
		if (ret<0)
			throw "The very end of the trajectory failed";
		/*Etape fin=trajet[trajet.size()-1];
		while (track.fMap(fin.x,fin.y)!=sqGoal)
		{
			if (track.fMap(fin.x,fin.y)!=sqPassable)
			{
				cout<<"ERREUR ! CRASH  LA FIN";
				break;
			}
			Move(fin.x,fin.y,fin.v,fin.d,false,true,false,false);
			Write(fin.x,fin.y,fin.v,fin.d,false,true,false,false);
		}*/
		cout<<"Final time : "<<tempsTot<<endl;
	}

	//Do the race and update the waypoints
	int UpdateTrajectory()
	{
		int tempsTot=0;
		for (int t=0; t<(int)trajet.size()-1; t++)
		{
//			cout<<trajet[t].d<<" ";
			Etape et;
			int ret=DureeEtape(trajet[t],trajet[t+1],et);
			if (ret<0)
			{
				cout<<"Erreur en "<<t<<endl;
				throw "Update of trajectory failed";
			}
			trajet[t+1]=et;
			tempsTot+=et.duree;
//			cout<<trajet[t+1].v<<",";
			cout<<".";
			cout.flush();
		}
		cout<<"\nTrajectory time : "<<tempsTot<<endl;
		Identical(0);
		//if (TestTrajectory(0,trajet[0])<0)
		//	throw "Something went wrong during trajectory update, it is no more valid.";
		return tempsTot;
	}

	//Throw an error if redoing the trajectory is different
	//For debugging purpose only
	void Identical(int t)
	{
		for (size_t u=t; u<trajet.size()-1; u++)
		{
			Etape ets;
			int ret=DureeEtape(trajet[u],trajet[u+1],ets);
			if (ret<0)
			{
				cout<<"At "<<u+1<<endl;
				throw "Not identical because failed";
			}
			if (ets.xx!=trajet[u+1].xx || ets.yy!=trajet[u+1].yy
					|| ets.d!=trajet[u+1].d
					|| ets.vv!=trajet[u+1].vv)
			{
				cout<<"At "<<u+1<<endl;
				throw "Not identical";
			}
		}
	}
		
	//Test the trajectory starting at time "t" 
	//with the new waypoint "et"
	//until the end
	//Return the new time
	int TestTrajectory(int t, Etape et)
	{
		int time=0;
		for (size_t u=t+1; u<trajet.size(); u++)
		{
			Etape ets;
			int ret=DureeEtape(et,trajet[u],ets);
			if (ret<0)
				return -1;
			time+=ret;
			et=ets;
		}
		return time;
	}

	void SimplifierTrajectoire()
	{
		for (int t=(int)trajet.size()-2; t>0; t--)
		{
			cout<<t<<" ";
			if (TestTrajectory(t,trajet[t-1])>=0)
			{
				size_t at=trajet.size();
				cout<<"["<<(int)at<<"] ";

				trajet.erase(&trajet[t]);
			}
			cout.flush();
		}
		cout<<"\nNumber of waypoints after simplification : "<<(int)trajet.size()<<endl;
		
		if (TestTrajectory(0,trajet[0])<0)
			throw "Something went wrong during trajectory simplification, it is no more valid.";
		
	//	SaveTrajet("%s_simple.bin");
	}

	void AccelererTrajectoire()
	{
		static const int64_t augmenter=int64_t(1.2*65536);
		int tempsModele=0;
		for (size_t t=1; t<trajet.size(); t++)
			tempsModele+=trajet[t].duree;
		cout<<"Optimize speed - was "<<tempsModele<<endl;
		
		int tempsDepart=trajet[trajet.size()-1].duree;
			
		for (size_t t=trajet.size()-2; t>0; t--)
		{
			tempsDepart+=trajet[t].duree;
						
			cout<<(int)t<<":";
			while (1)
			{
				Etape et=trajet[t];
				et.v=(int)fmult(et.v,augmenter);
				if (et.v<1000)
					et.v=1000;
				
				Etape fin;
				int newTimeWP=DureeEtape(trajet[t-1],et,fin);
				if (newTimeWP<0)
					break;

				int newTime=TestTrajectory(t,fin);
				if (newTime<0 || newTime+newTimeWP>=tempsDepart)
					break;
				
				trajet[t]=fin;
				cout<<"->"<<fin.v;
				tempsDepart=newTime+newTimeWP;
			}
			cout<<endl;
		}
		if (UpdateTrajectory()!=tempsDepart)
			throw "bob acclrer";
	//	SaveTrajet("%s_acc.bin");
	}

	void MoveWayPoints(int sens1, int sens2)
	{
		int tempsModele=0;
		for (size_t t=1; t<trajet.size(); t++)
			tempsModele+=trajet[t].duree;
		cout<<"Optimize position - was "<<tempsModele<<endl;
		int tempsDepart=trajet[trajet.size()-1].duree;
			
		for (size_t t=trajet.size()-2; t>0; t--)
		{
			tempsDepart+=trajet[t].duree;
			cout<<(int)t<<":";
			while (1)
			{
				Etape et=trajet[t];
				int moyx=(trajet[t-1].xx+trajet[t+1].xx)/2;
				int moyy=(trajet[t-1].yy+trajet[t+1].yy)/2;
				int dx=sens1*(et.xx-moyx)/10;
				int dy=sens2*(et.yy-moyy)/10;
				et.x+=dx;
				et.y+=dy;
				
				Etape fin;
				int newTime1=DureeEtape(trajet[t-1],et,fin);
				if (newTime1<0)
					break;
				
				int newTime=TestTrajectory(t,fin);
				if (newTime<0 || newTime+newTime1>=tempsDepart)
					break;
				
				trajet[t]=fin;
				cout<<"->"<<fin.x<<","<<fin.y;
				tempsDepart=newTime+newTime1;
			}
			cout<<endl;
		}
		if (UpdateTrajectory()!=tempsDepart)
			throw "bob move";
	}
	
	void Move(int & x, int & y, int & v, int & d,
		bool brake, bool accelerate, bool turnLeft, bool turnRight)
	{
		v-=int(F0+fmult(F1,v)+fmult(F2,fmult(v,v)));
		if (accelerate)
			v+=A;
		if (brake)
			v-=B;
		if (v<0)
			v=0;
		if (turnLeft)
			d-=(int)fdiv(T,fmult(v,v)+L);
		if (turnRight)
			d+=(int)fdiv(T,fmult(v,v)+L);
		while (d<-pi)
			d+=pi2;
		while (d>pi)
			d-=pi2;
		x+=(int)fmult(v,fcos(d));
		y+=(int)fmult(v,fsin(d));
	}

	void Test()
	{
		ifstream F("Een.trc");
		ofstream G("test.txt");
		int x=23265280,y=21102592,v=0,d=0;
		//23265280  21102592         0         0
		bool acc=false,br=false,tl=false,tr=false;
		int t=0;
		while (!F.eof())
		{
			char c=F.get();
            switch(c)
			{
			case 'b':
				br=true;
				break;
			case 'a':
				acc=true;
				break;
			case 'l':
				tl=true;
				break;
			case 'r':
				tr=true;
				break;
			case '.':
				{
					Move(x,y,v,d,br,acc,tl,tr);
					G<<++t<<" "<<x<<" "<<y<<" "<<v<<" "<<d<<endl;
					tr=br=acc=tl=false;
					break;
				}
			}
		}
	}
}car;


int main(int argc, char**argv)
{
//	car.Test();
	if (argc<2)
	{
		cout<<"Give the track name as parameter, without the trk extension.\n";
		return 0;
	}

	try
	{
		track.Open(argv[1]);
		car.Race();
	}
	catch(const char * erreur)
	{
		cout<<"** FAILED **"<<endl;
		cerr<<erreur<<endl;
	}
	catch(Finished)
	{
		track.SauverTraj();
		cout<<"** SUCCEED **"<<endl;
	}
	return 0;
}
